// Complaint_Register.cpp: implementation of the Complaint_Register class.
//
//////////////////////////////////////////////////////////////////////

#include "Complaint_Register.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template <class T>

//Default Constructor

Complaint_Register<T>::Complaint_Register()
{
	address_number=0;
	List<T>();
}

template <class T>

//Destructor

Complaint_Register<T>::~Complaint_Register()
{
	Old_Customers.Delete_List();
	Todays_Customers.Delete_List();
	address_number=0;	
}

template <class T>

//returns the current size of the list

int Complaint_Register<T>:: Get_Size()
{
	return Todays_Customers.Get_size();
}

template <class T>

// returns the next job to be done

T Complaint_Register<T> :: Next_Job(ifstream& input)
{	
	if (input>>address_number)
	{
		bool check=false;
	
		check=Old_Customers.Check_Customer(address_number);

		if (check)
			Todays_Customers.Insert_At_Front(address_number);	
		else
			Todays_Customers.Insert_Node(address_number);
	}		
	
	return Todays_Customers.Get_Customer();
}

template <class T>

// Stream insertion operator is used to input the values from input file

istream &operator>>(istream &input, Complaint_Register<T>& p)
{
	while (input>>p.address_number)
	{
		p.Old_Customers.Insert_Node(p.address_number);
		p.Todays_Customers.Insert_Node(p.address_number);
	}

	return input;
}

template <class T>

// Stream extraction operator is used to output the values to the output file

ostream &operator<< (ostream &output, Complaint_Register<T>& p)
{		
	p.Old_Customers.Display_List("O L D  C U S T O M E R S ",output);
	p.Todays_Customers.Display_List("T O D A Y  C U S T O M E R S",output);
	return output;
}
